//%attributes = {}
// ldcap_ WEEK_LOAD_GET (kInit|kGet;tLG;lWeek;lPreviousWorks;->rCapacity;-
// 2004.10.13-13:20:38 / Arto Kokkila
// © Copyright 2004 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_TEXT:C284($2; $ld_tLoadGroup)
C_LONGINT:C283($1; $ld_lAction; $3; $ld_lWeek; $4; $ld_lEndWeek; $5; $ld_lGetPreviousWorks; $8; $ld_lCalcLoadFromCriticalDate)
C_LONGINT:C283($ld_lIndex; $ld_lIndex2; $ld_lRunLoop)
C_POINTER:C301($6; $ld_pCapacity; $7; $ld_pLoaded)

C_REAL:C285($ld_rWeekCapacity; $ld_rWeekLoad)  //values to return
C_DATE:C307($ld_dWeekStartDate; $ld_dWeekEndDate)
C_LONGINT:C283($ld_lIndex; $ld_lWeekStartIndex)
C_REAL:C285($ld_rPhaseLoad; $ld_rCapacity; $ld_rMultiplier; $ld_rCapacityStartDateTime; $ld_rCapacityEndDateTime)

$ld_lAction:=$1
$ld_tLoadGroup:=$2
$ld_lWeek:=$3
$ld_lEndWeek:=$4
$ld_lGetPreviousWorks:=$5
$ld_pCapacity:=$6
$ld_pLoaded:=$7
$ld_lCalcLoadFromCriticalDate:=$8

Case of 
	: ($ld_lAction=kInit)
		
		//week does not matter, only cap start date
		//$ld_lForceReload:=$2
		//$ld_lRecalculate:=$3
		//$ld_lAddToExistingArr:=$4
		ld_WORK_ARR_NEXT_LOAD_FORCE  // ak 2014-11-24
		ld_WORK_ARR_LOAD($ld_tLoadGroup; kFalse; kFalse; kFalse)
		ldcap_FREE_CACLULATE(ld_tLoad_Group_id; 0; $ld_lCalcLoadFromCriticalDate)  //;ld_dCapacityStartDate;ld_hCapacityStartTime)
		
	: ($ld_lAction=kGet)
		$ld_rPhaseLoad:=0
		$ld_rWeekLoad:=0
		$ld_rWeekCapacity:=0
		If (Size of array:C274(ldcap_arCapacity)>0)
			$ld_dWeekStartDate:=_week_ ToWeekStartDate($ld_lWeek)  //monday
			$ld_dWeekEndDate:=_week_ ToWeekEndDate($ld_lEndWeek)  //sunday
			$ld_lWeekStartIndex:=Find in array:C230(ldcap_alStartWeek; $ld_lWeek)  //find week start
			If ($ld_lWeekStartIndex<=0)
				IDLE:C311  // v12, no error needed
				//_err MESSAGE (_lang Current ("Week capacity was not found")+" ("+$ld_tLoadGroup+"/"+_week ToString ($ld_lWeek)+")";Current method name;kFalse)
			Else 
				//---------- calculate capacity first ----------
				$ld_lIndex:=$ld_lWeekStartIndex
				If ($ld_lIndex>1)  //this is before while loop, so comes only once
					If (ldcap_adEndDate{$ld_lIndex-1}>=$ld_dWeekStartDate)  //Previous capacity ends on this week
						$ld_lIndex:=$ld_lIndex-1
					End if 
				End if 
				
				While ($ld_lIndex>0)
					
					//get one phase capacity            
					Case of 
						: ($ld_lGetPreviousWorks=kTrue)
							$ld_rCapacity:=ldcap_arCapacity{$ld_lIndex}
							//previous works always to this weeks full cap from monday
							//even if we are already in the middle of week
						: (ldcap_adStartDate{$ld_lIndex}<ldcap_dCapacityStartDate)
							$ld_rCapacity:=0
							//: (ldcap_adStartDate{$ld_lIndex}=ldcap_dCapacityStartDate)
							//    capacity is agreed to come from day start, not from current time
						Else 
							$ld_rCapacity:=ldcap_arCapacity{$ld_lIndex}  // ld_arCapCapacity is already multiplied to effective
					End case 
					
					//get week capacity
					$ld_rMultiplier:=1
					Case of 
						: ($ld_lIndex>=$ld_lWeekStartIndex)  //normal cases
							$ld_rWeekCapacity:=$ld_rWeekCapacity+$ld_rCapacity
						: (ldcap_adEndDate{$ld_lIndex}>=$ld_dWeekStartDate)  //Previous capacity ends on this week
							$ld_rCapacityStartDateTime:=ldcap_arStart{$ld_lIndex}
							$ld_rCapacityEndDateTime:=ldcap_arEnd{$ld_lIndex}
							$ld_rWeekDateTime:=_dt ToReal($ld_dWeekStartDate; ?00:00:00?)
							If ($ld_rCapacityEndDateTime>$ld_rCapacityStartDateTime)
								If ($ld_rCapacityEndDateTime>$ld_rWeekDateTime)
									$ld_rMultiplier:=($ld_rCapacityEndDateTime-$ld_rWeekDateTime)/($ld_rCapacityEndDateTime-$ld_rCapacityStartDateTime)
								Else 
									$ld_rMultiplier:=0
								End if 
							Else 
								$ld_rMultiplier:=0
							End if 
							$ld_rWeekCapacity:=$ld_rWeekCapacity+($ld_rCapacity*$ld_rMultiplier)
						Else 
							IDLE:C311  //last capacity goes to next week is handled below in code
					End case 
					
					$ld_lIndex:=$ld_lIndex+1  //check next capacity
					Case of 
						: ($ld_lIndex>Size of array:C274(ldcap_alStartWeek))
							$ld_lIndex:=-1  //end loop
							//error message here!!!
						: (ldcap_adStartDate{$ld_lIndex}>$ld_dWeekEndDate)
							//week end reached, next capacity start date after this week
							$ld_lIndex:=-1  //end loop
							
						: (ldcap_adEndDate{$ld_lIndex}>$ld_dWeekEndDate)
							//Last capacity ends on next week - take this week part of load & capacity
							$ld_rCapacityStartDateTime:=ldcap_arStart{$ld_lIndex}
							$ld_rCapacityEndDateTime:=ldcap_arEnd{$ld_lIndex}
							$ld_rWeekDateTime:=_dt ToReal($ld_dWeekEndDate; ?24:00:00?)
							If ($ld_rCapacityEndDateTime>$ld_rCapacityStartDateTime)
								If ($ld_rWeekDateTime>$ld_rCapacityStartDateTime)
									$ld_rMultiplier:=($ld_rWeekDateTime-$ld_rCapacityStartDateTime)/($ld_rCapacityEndDateTime-$ld_rCapacityStartDateTime)
									$ld_rCapacity:=ldcap_arCapacity{$ld_lIndex}*$ld_rMultiplier
									$ld_rWeekCapacity:=$ld_rWeekCapacity+$ld_rCapacity
								End if 
							End if 
							//*** Calculate this week part ***
							$ld_lIndex:=-1  //end loop
						Else 
							IDLE:C311  //normal case when we are not in the last capacity of the week
					End case 
					
				End while 
				
				
				//---------- calculate load  ---------- 
				
				$ld_dCapStartDate:=ldcap_dCapacityStartDate
				If ($ld_lGetPreviousWorks=kTrue)
					//set week start to capacity start date, everything before is in previous weeks so
					//we need to get date previous from current date to get previous loading
					//or current date's index where to start calculatin load (later after this if)
					
					
					If (ldcap_dCapacityStartDate<$ld_dWeekStartDate)
						IDLE:C311  //before:  $ld_dCapStartDate:=ldcap_dCapacityStartDate
					Else 
						$ld_dCapStartDate:=$ld_dWeekStartDate
					End if 
					$ld_lIndex:=ldcap_IndexFirst($ld_tLoadGroup; $ld_dCapStartDate)
					$ld_lIndex:=$ld_lIndex-1
					
					//calculate previous weeks loading, including this weeks past dates
					//it's cumulative free = load before this day
					$ld_rWeekLoad:=-ldcap_arCumulativeFree{$ld_lIndex}  //here is the result we need
					
					If ($ld_lIndex<($ld_lWeekStartIndex-1))
						If ($ld_lIndex<Size of array:C274(ldcap_adStartDate))
							$ld_lWeekStartIndex:=$ld_lIndex+1
							If (ldcap_adStartDate{$ld_lWeekStartIndex}<$ld_dWeekStartDate)
								$ld_lGetPreviousWorks:=kFalse  //calculate next need from cap start date to start date
								$ld_dWeekEndDate:=$ld_dWeekStartDate-1
							End if 
						End if 
					End if 
					
				End if 
				
				
				If ($ld_lGetPreviousWorks=kFalse)
					//calculate only weeks(remaining) loading
					//load is calculated by one phase at a time and basic formula is: 
					//load = ldcap_arCapacity{$ld_lIndex} - ldcap_arCurrentFree{$ld_lIndex}
					
					If ($ld_dCapStartDate<$ld_dWeekStartDate)
						$ld_lIndex:=$ld_lWeekStartIndex  //calculate next need from cap start date to start date
					Else 
						$ld_lIndex:=ldcap_IndexFirst($ld_tLoadGroup; $ld_dWeekStartDate)
					End if 
					// If ($ld_lIndex>1)  `this is before while loop, so comes only once
					//            If (ldcap_adEndDate{$ld_lIndex-1}>=$ld_dWeekStartDate)  `Previous 
					//~capacity ends on this week
					//              $ld_lIndex:=$ld_lIndex-1
					//            End if 
					//          End if  
					
					$ld_rMultiplier:=1  //only part of the day if phase is not fully inside needed time from start or end
					While ($ld_lIndex>0)
						
						//get one phase capacity         
						
						//           If (ldfl_arFLCapStartDateTime{$ld_lFlIndex}>=$ld_rCapacityStartDate
						//~Time)  `show  later capacity too         
						//              ldfl_arFLCapFreeCapacity{$ld_lFlIndex}:=ldfl_arFLCapCapacity{$ld
						//~_lFlIndex}-ldcap_arCurrentFree{$ld_lIndex}
						//            Else 
						//              ldfl_arFLCapFreeCapacity{$ld_lFlIndex}:=-ldcap_arCurrentFree{$ld
						//~_lIndex}
						//            End if            
						
						If (ldcap_adStartDate{$ld_lIndex}<ldcap_dCapacityStartDate)
							$ld_rCapacity:=0
						Else 
							$ld_rCapacity:=ldcap_arCapacity{$ld_lIndex}  // ld_arCapCapacity is already multiplied to effective
						End if 
						//            $ld_rMultiplier:=($ld_rCapacityEndDateTime-$ld_rWeekDateTime)/($ld
						//~_rCapacityEndDateTime-$ld_rCapacityStartDateTime)'     
						$ld_rPhaseLoad:=($ld_rCapacity*$ld_rMultiplier)-(ldcap_arCurrentFree{$ld_lIndex}*$ld_rMultiplier)
						$ld_rWeekLoad:=$ld_rWeekLoad+$ld_rPhaseLoad
						
						$ld_lIndex:=$ld_lIndex+1
						Case of   //check next capacity
							: ($ld_lIndex>Size of array:C274(ldcap_alStartWeek))
								$ld_lIndex:=-1
								//error message here!!!
							: (ldcap_adStartDate{$ld_lIndex}>$ld_dWeekEndDate)
								//week end reached, next capacity start date after this week
								$ld_lIndex:=-1  //end loop
								
							: (ldcap_adEndDate{$ld_lIndex}>$ld_dWeekEndDate)
								//Last capacity ends on next week - take this week part of load & capacity
								$ld_rCapacityStartDateTime:=ldcap_arStart{$ld_lIndex}
								$ld_rCapacityEndDateTime:=ldcap_arEnd{$ld_lIndex}
								$ld_rWeekDateTime:=_dt ToReal($ld_dWeekEndDate; ?24:00:00?)
								If ($ld_rCapacityEndDateTime>$ld_rCapacityStartDateTime)
									If ($ld_rWeekDateTime>$ld_rCapacityStartDateTime)
										$ld_rMultiplier:=($ld_rWeekDateTime-$ld_rCapacityStartDateTime)/($ld_rCapacityEndDateTime-$ld_rCapacityStartDateTime)
										$ld_rCapacity:=ldcap_arCapacity{$ld_lIndex}*$ld_rMultiplier
										$ld_rWeekCapacity:=$ld_rWeekCapacity+$ld_rCapacity
										$ld_rPhaseLoad:=$ld_rCapacity-(ldcap_arCurrentFree{$ld_lIndex}*$ld_rMultiplier)
										$ld_rWeekLoad:=$ld_rWeekLoad+$ld_rPhaseLoad
									Else 
										IDLE:C311
									End if 
								End if 
								//*** Calculate this week part ***
								$ld_lIndex:=-1  //end loop
							Else 
								IDLE:C311
						End case 
						
					End while 
				End if 
				
			End if 
		End if 
		
		If ($ld_rWeekLoad<0)
			$ld_rWeekLoad:=0
		End if 
		$ld_pCapacity->:=$ld_rWeekCapacity
		$ld_pLoaded->:=$ld_rWeekLoad
	Else 
		_err MESSAGE_PARAMETER("$1"; Current method name:C684; kFalse)
End case 

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 
